{cura compositi}

TITLE 'kinetic '

SELECT
!errlim=0.01


VARIABLES
alfa (1)

DEFINITIONS

lc=0.001{m}
b=0.001{m}


k01=10.44 ! ln(1/s)
E1=62400
n=1.07

rate=2
!Te=min(303+rate/60*t,473)
Te=130+273

k1=exp(k01-E1/(8.314*Te))

INITIAL VALUES

alfa=0

EQUATIONS
alfa: dt(alfa)=k1*(1-alfa)^n

BOUNDARIES

Region 1


start (0,0)
natural(alfa)=0 line to (lc,0)
natural(alfa)=0 line to (lc,b)
natural(alfa)=0 line to (0,b)
natural(alfa)=0  line to finish


TIME
from 0 to 50000 by 1

MONITORS
for t=0 by 10 to 50000


PLOTS
for t=0 by 10 to 50000

!elevation(alfa) from (0,b/2) to (lc,b/2) as "Grado di reazione"


HISTORIES

history(alfa) at  (lc/2,b/2) export format "#t#r,#i" file="ldtalfa.txt"
history(Te) at  (lc/2,b/2)
history (dt(alfa)) at  (lc/2,b/2)

END

