{cinetica}

TITLE 'modello a 2 costanti '

SELECT
!errlim=0.001
!fixdt

VARIABLES

alfa (1)

DEFINITIONS
lc=0.001
b=0.001


p=-0.0317
q=0.00235 {1/K}

k01=10.1
E1=55670 {J/mol}
k02=20.3
E2=74500 {J/mol}
m=1.6
n=1.4



rate=3 {K/min}
Te=min(298+rate/60*t,395)
!Te=430

k1=exp(k01-E1/(8.314*Te))
k2=exp(k02-E2/(8.314*Te))


alfamax= IF (Te<439)  then (p+q*Te) else 1
!deltalfa=(alfamax-alfa)
deltalfa=if (alfamax-alfa)<0 then 0 else (alfamax-alfa)




INITIAL VALUES

alfa=0

EQUATIONS
alfa: dt(alfa)=(k1+k2*alfa^m)*deltalfa^n

BOUNDARIES
Region 1
start (0,0)
 line to (lc,0)
 line to (lc,b)
 line to (0,b)
 line to close



TIME
from 0 to 3500 by 1

MONITORS
for t=0 by 10 to 3500


PLOTS
for t=0 by 10 to 3500


!elevation(alfa) from (0,b/2) to (lc,b/2) as "Grado di reazione"


HISTORIES

history(alfa) at  (lc/2,b/2) as "grado di reazione "  !export format "#t#r,#i" file="alfa.txt"
history(dt(alfa)) at  (lc/3,b/2)
history (te-273) at  (lc/3,b/2)
history (alfamax) at  (lc/3,b/2)

END



