{cura compositi}

TITLE 'composite curing '

SELECT
!errlim=0.001
! fixdt



VARIABLES
Temp
alfa (1)

DEFINITIONS
!kx  h cp r  Dh
lc=0.003{m}
b=0.001 {m}



kx=0.38
cp=1200
r=1600{kg/m^3}
HR=450 {J/g of resin}

hc=50 {W/m^2C}

p=-0.0317
q=0.00235 {1/K}

k01=10.13 !  ln kinetic constant, 1/s
E1=55670
k02=20.32
E2=74500
m=1.6
n=1.4

k1=exp(k01-E1/(8.314*Temp))
k2=exp(k02-E2/(8.314*Temp))

Dh=HR*0.35*1000 {J/kg}

rate=2 {K/min}
Te=min(298+rate/60*t,353)

alfamax= IF (Te<439)  then (p+q*Te) else 1
deltalfa=if (alfamax-alfa)<0 then 0 else (alfamax-alfa)

!deltalfa=if (1-alfa)<0 then 0 else (1-alfa)

INITIAL VALUES
Temp=25+273
alfa=0

EQUATIONS
temp: r*cp*dt(Temp)=kx*dxx(Temp)+kx*dyy(Temp)+r*Dh*dt(alfa)
alfa: dt(alfa)=(k1+k2*alfa^m)*deltalfa^n

BOUNDARIES


Region 1
start (0,0)
!natural  (temp)=hc*(Temp-Te) line to (0,b)
Value (Temp)=Te line to (0,b)
natural (Temp)=0   line to (lc,b)
value (temp)=Te line to (lc,0)
!natural  (temp)=hc*(Temp-Te) line to (lc,0)
natural (Temp)=0 line to close


TIME
from 0 to 6000 by 1

!MONITORS
!for t=0 by 1 to 4000


PLOTS
for t=0 by 100 to 6000
elevation(Temp-273) from (0,b/2) to (lc,b/2) as "Temperatura, C"
elevation(alfa) from (0,b/2) to (lc,b/2) as "Grado di reazione"


HISTORIES
history(Temp-273) at  (0,b/2) (lc/2,b/2) (lc/3,b/2) (lc,b/2)
!history(Temp) at (lc,b/2)
history(alfa) at   (0,b/2) (lc/2,b/2)  (lc,b/2)


END



