{cura compositi}

TITLE 'lastra '

SELECT
!terrlim=0.001
fixdt



VARIABLES
Temp
alfa (0.1)

DEFINITIONS
kx  h cp r  Dh

lc=0.008{m}
b=0.0008 {m}
ls=0.08 {m}

kxs=56.3 {conducibilit termica stampo W/mC}
kxc=0.45 {conducibilit termica composito W/mC}
cps=490{J/KgC}
cpc=1200
rs=7830{Kg/m^3}
rc=1600{Kg/m^3}

hc1=50 {W/m^2C}
hc2=50 {W/m^2C}

k01=10.13 {expressed as natural logarythm 1/s}
E1=55670
k02=20.32  {expressed as natural logarythm 1/s}
E2=74500
m=1.6
n=1.4
p=-0.0317
q=0.00235 {1/K}

k1=exp(K01-E1/(8.314*Temp))
k2=exp(K02-E2/(8.314*Temp))

Tinit=298

Dhp=450*0.35*1000 {J/kg}

rate=3 {K/min}
Te=min(298+rate/60*t,345)

alfamax= IF (Temp<438)  then (p+q*Temp)  else 1
!alfamax = if dt(Temp)<0 then alfa else p+q*Temp
!eta = IF (alfa <0.39) then exp(etak-Eeta/(8.314*Te))*(alfag/(alfag-alfa))^A else 3e3
!alfamax=p+q*Temp
deltalfa=if (alfamax-alfa)<0 then 0 else (alfamax-alfa)
INITIAL VALUES
Temp=Tinit
alfa=0

EQUATIONS
!temp: r*cp*dt(Temp)=kx*dxx(Temp)+r*Dh*((k1+k2*alfa^m)*Deltalfa^n)
!alfa: dt(alfa)=(k1+k2*alfa^m)*deltalfa^n
temp: r*cp*dt(Temp)=kx*dxx(Temp)+r*Dh*dt(alfa)
alfa: dt(alfa)=(k1+k2*alfa^m)*(alfamax-alfa)^n


BOUNDARIES

Region 1
kx=kxc  cp=cpc r=rc Dh=Dhp h=hc1 !Tinit=308
start (0,0)
natural (temp)=h*(Temp-Te) line to (0,b)
natural (Temp)=0   line to (lc,b)
		 line to (lc,0)
natural (Temp)=0 line to close

Region 2
kx=kxs  cp=cps r=rs h=hc2 Dh=0
start (lc,0)
natural (temp)=0 line to (lc+ls,0)
natural (temp)=h*(Temp-Te)  line to (lc+ls,b)
 natural (Temp)=0 line to (lc,b)
 		line to close


TIME
from 0 to 21000 by 2

!MONITORS
!for t=0 by 1 to 10000


PLOTS
for t=0 by 10 to 21000
elevation(Temp-273) from (0,b/2) to (lc+ls,b/2) as "Temperatura"
elevation(alfa) from (0,b/2) to (lc,b/2) as "Grado di reazione"
!elevation(alfamax) from (0,b/2) to (lc,b/2) as "Grado di reazione"


HISTORIES
history(Temp-273) at   (0,b/2) (lc/2,b/2) (lc,b/2) (lc+ls,b/2)
!history(Te-273) at (0,b/2)
history(alfa) at   (0,b/2) (lc/2,b/2) (lc,b/2)


END


